<?php
include 'api/functions.php';

if (!isset($_REQUEST['token'])) {
    error_msg('Something went wrong, please contact to the team.');
}

$token = $_REQUEST['token'];
$result = fetchScore($token);
if ($result['status'] == 'Completed') {
    error_msg('Test completed already.<br> Our team will be in touch with you shortly.', 'success');
}

$_SESSION['token'] = $token;
$_SESSION['candidate_id'] = $result['candidate_id'];
$_SESSION['time'] = time();
$conn->close();
?>

<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Invitra MCQ Test</title>
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Poppins:wght@400&family=Ubuntu:wght@300&display=swap");

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;
            user-select: none;
        }

        ::-webkit-scrollbar {
            width: 0;
            height: 0;
        }

        body {
            position: relative;
            height: 99vh;
            display: flex;
            justify-content: center;
            align-items: center;
            /* background: linear-gradient(45deg, crimson, #0390c8); */
            background: #0083bb;
        }

        .starter {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            min-width: 400px;
            height: 200px;
            background-color: #eee;
            border-radius: 5px;
            box-shadow: 0 0 10px 5px #c1c1c120;
            padding: 0 10px;
            filter: drop-shadow(0px 0px 10px #e2f9ff8d);
        }

        .starter button {
            padding: 10px 20px;
            font-size: 1.7rem;
            border: none;
            border-radius: 3px;
            outline: none;
            background-color: #0091ff;
            cursor: pointer;
            box-shadow: 0 0 10px 5px #00000020;
        }
    </style>
</head>

<body>
    <div class="starter">
        <button onclick="start()">Start MCQ Test</button>
    </div>

    <script src="assets/js/script.js?ver="<?php echo time(); ?>></script>
    <script>
        function start() {
            if (confirm("Are you sure you want to start the MCQ test? Please confirm to proceed.")) {
                window.location.href ='<?php echo $base_url . "/api/start.php"; ?>'
            }
        }
    </script>
</body>
</html>
