// Disable right-click context menu
document.addEventListener('contextmenu', function (event) {
  event.preventDefault();
});

// Disable specific keyboard shortcuts
document.addEventListener('keydown', function (event) {
  if (event.key === 'F12' || // Open developer tools
    (event.ctrlKey && event.key === 't') || // Open new tab
    (event.ctrlKey && event.shiftKey && event.key === 'n') || // Open new window
    (event.ctrlKey && event.key === 'n') || // Open new window
    (event.ctrlKey && event.key === 'w') || // Close current tab
    (event.ctrlKey && event.shiftKey && event.key === 'I') || // Open developer tools
    (event.ctrlKey && event.shiftKey && event.key === 'J') || // Open developer console
    (event.ctrlKey && event.key === 'U')) { // View page source
    event.preventDefault();
  }
});

// Detect if developer tools are open
function detectDevTools() {
  const threshold = 100;
  let devtoolsOpen = false;

  setInterval(() => {
    const start = performance.now();
    debugger;
    const end = performance.now();
    if (end - start > threshold) {
      if (!devtoolsOpen) {
        devtoolsOpen = true;
        alert('Developer tools detected. Please close them to continue.');
        // Optional: Redirect or take other actions
      }
    } else {
      devtoolsOpen = false;
    }
  }, 1000);
}

detectDevTools();

// Prevent leaving the page
// window.addEventListener('beforeunload', function (event) {
//   event.preventDefault();
//   event.returnValue = ''; // Some browsers require a return value to show the dialog
// });

// Disable link clicks
document.addEventListener('click', function (event) {
  if (event.target.tagName === 'A') {
    event.preventDefault();
    alert('Link clicks are disabled on this page.');
  }
});

function confirmAndSubmit() {
  const userConfirmed = confirm("Are you sure you want to submit your answers? Please confirm to proceed, as you won't be able to make any changes after submission.");

  if (userConfirmed) {
    document.getElementById('mcqTestForm').submit();
  }
}